Rem AddPoints.vbs
Rem An InDesign VBScript
Rem
Rem Adds points to the paths of the selected page item(s). Points are added at the midpoint of
Rem each line segment on curved line segments, the added point may be closer to one end point
Rem than it is to the other. This is because the "midpoint" is determined based on the "velocity"
Rem of the curve.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2024")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            For myCounter = 0 To UBound(myObjectList)
	                Set myObject = myObjectList(myCounter)
	                For myPathCounter = 1 To myObject.Paths.Count
	                	Rem Store current ruler origin, measurement units.
	                	myOldRulerOrigin = myInDesign.Documents.Item(1).ViewPreferences.RulerOrigin
	                	myOldXUnits = myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits
	                	myOldYUnits = myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits
	                	Rem Change ruler origin, measurement units.
	                	myInDesign.Documents.Item(1).ViewPreferences.RulerOrigin = idRulerOrigin.idPageOrigin
	                	myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
	                	myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
	                    myAddPoints myObject.Paths.Item(myPathCounter)
						Rem Reset ruler origin, measurement units.
	                	myInDesign.Documents.Item(1).ViewPreferences.RulerOrigin = myOldRulerOrigin
	                	myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
	                	myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits = myOldYUnits
	                Next
	            Next
	        End If
	    Else
	        MsgBox ("Please select a rectangle, ellipse, polygon, graphic line, or text frame and try again.")
	    End If
	Else
	    MsgBox ("Please open a document, select an object, and try again.")
	End If
End function
Function myAddPoints(myPath)
    Dim myPointArray()
    Rem Make the array large enough to hold the points we'll be putting into it.
    If myPath.PathType = idPathType.idClosedPath Then
        ReDim myPointArray((myPath.PathPoints.Count * 2) - 1)
    Else
        ReDim myPointArray((myPath.PathPoints.Count * 2) - 2)
    End If
    For myPathPointCounter = 1 To myPath.PathPoints.Count
        Set myPathPoint = myPath.PathPoints.Item(myPathPointCounter)
        If myPathPointCounter < myPath.PathPoints.Count Then
            Set myNextPathPoint = myPath.PathPoints.Item(myPathPointCounter + 1)
        Else
            Set myNextPathPoint = myPath.PathPoints.Item(1)
        End If
        Rem Get the anchor of the current point.
        myBx0 = myPathPoint.Anchor(0)
        myBy0 = myPathPoint.Anchor(1)
        Rem Get the right direction of the current point.
        myBx1 = myPathPoint.RightDirection(0)
        myBy1 = myPathPoint.RightDirection(1)
        Rem Get the left direction of the *next* point.
        myBx2 = myNextPathPoint.LeftDirection(0)
        myBy2 = myNextPathPoint.LeftDirection(1)
        Rem Get the anchor of the *next* point.
        myBx3 = myNextPathPoint.Anchor(0)
        myBy3 = myNextPathPoint.Anchor(1)
        myPoints = myCalculatePoints(myBx0, myBy0, myBx1, myBy1, myBx2, myBy2, myBx3, myBy3)
        myPointA = myPoints(0)
        myPointB = myPoints(1)
        myPointC = myPoints(2)
        Rem Add the points to the path point array.
        Rem If the point is the first point in the array, set it otherwise
        Rem set the previous point's right direction.
        If myPathPointCounter = 1 Then
            myPointArray(0) = myPointA
            Rem Add the intermediate point.
            myPointArray(1) = myPointB
            Rem Add the end point of the current line segment.
            myPointArray(2) = myPointC
        Else
            If myPathPointCounter = (myPath.PathPoints.Count) Then
                If myPath.PathType = idPathType.idClosedPath Then
                    Rem Adjust the right direction of the preceding point.
                    myPointArray((myPathPointCounter - 1) * 2)(2) = myPointA(2)
                    Rem Add the intermediate point.
                    myPointArray(((myPathPointCounter - 1) * 2) + 1) = myPointB
                    Rem Adjust the left direction of the first point.
                    myPointArray(0)(0) = myPointC(0)
                End If
            Else
                Rem Adjust the right direction of the preceding point.
                myPrecedingPoint = myPointArray(myPathPointCounter * 2)
                myPointArray((myPathPointCounter - 1) * 2)(2) = myPointA(2)
                Rem Add the intermediate point.
                myPointArray(((myPathPointCounter - 1) * 2) + 1) = myPointB
                Rem Add the end point of the current line segment.
                myPointArray(((myPathPointCounter - 1) * 2) + 2) = myPointC
            End If
        End If
    Next
    Rem Now apply the array of triples (left direction, anchor, right direction) to the path.
    myPath.EntirePath = myPointArray
End Function

Function myCalculatePoints(myBx0, myBy0, myBx1, myBy1, myBx2, myBy2, myBx3, myBy3)
    If myBx1 = myBx0 And myBy1 = myBy0 And myBx2 = myBx3 And myBy2 = myBy3 Then
        Rem Anchor of point 1 of segment 1
        myCx0 = myBx0
        myCy0 = myBy0
        Rem Anchor of point 2 of segment 1
        myCx3 = (myBx3 + (3 * myBx2) + (3 * myBx1) + myBx0) * 0.125
        myCy3 = (myBy3 + (3 * myBy2) + (3 * myBy1) + myBy0) * 0.125
        Rem Anchor of point 1 of segment 2 (not really necessary same as ending of segment 1)
        myDx0 = (myBx3 + (3 * myBx2) + (3 * myBx1) + myBx0) * 0.125
        myDy0 = (myBy3 + (3 * myBy2) + (3 * myBy1) + myBy0) * 0.125
        Rem Anchor of point 2 of segment 2
        myDx3 = myBx3
        myDy3 = myBy3
        Rem RightDirection of point 1 of segment 1
        myCx1 = myCx0
        myCy1 = myCy0
        Rem LeftDirection of point 2 of segment 1
        myCx2 = myCx3
        myCy2 = myCy3
        Rem RightDirection of point 2 of segment 1 (i.e., point 1 of segment 2)
        myDx1 = myDx0
        myDy1 = myDy0
        Rem LeftDirection of point 2 of segment 2
        myDx2 = myDx3
        myDy2 = myDy3
    Else
        Rem Anchor of point 1 of segment 1
        myCx0 = myBx0
        myCy0 = myBy0
        Rem RightDirection of point 1 of segment 1
        myCx1 = (myBx1 + myBx0) * 0.5
        myCy1 = (myBy1 + myBy0) * 0.5
        Rem LeftDirection of point 2 of segment 1
        myCx2 = (myBx2 + (2 * myBx1) + myBx0) * 0.25
        myCy2 = (myBy2 + (2 * myBy1) + myBy0) * 0.25
        Rem anchor of point 2 of segment 1
        myCx3 = (myBx3 + (3 * myBx2) + (3 * myBx1) + myBx0) * 0.125
        myCy3 = (myBy3 + (3 * myBy2) + (3 * myBy1) + myBy0) * 0.125
        Rem Anchor of point 1 of segment 2 (not really necessary same as ending of segment 1)
        myDx0 = (myBx3 + (3 * myBx2) + (3 * myBx1) + myBx0) * 0.125
        myDy0 = (myBy3 + (3 * myBy2) + (3 * myBy1) + myBy0) * 0.125
        Rem RightDirection of point 2 of segment 1 (i.e., point 1 of segment 2)
        myDx1 = (myBx3 + (2 * myBx2) + myBx1) * 0.25
        myDy1 = (myBy3 + (2 * myBy2) + myBy1) * 0.25
        Rem LeftDirection of point 2 of segment 2
        myDx2 = (myBx3 + myBx2) * 0.5
        myDy2 = (myBy3 + myBy2) * 0.5
        Rem Anchor of point 2 of segment 2
        myDx3 = myBx3
        myDy3 = myBy3
    End If
    myPointA = Array(Array(myBx0, myBy0), Array(myCx0, myCy0), Array(myCx1, myCy1))
    myPointB = Array(Array(myCx2, myCy2), Array(myCx3, myCy3), Array(myDx1, myDy1))
    myPointC = Array(Array(myDx2, myDy2), Array(myDx3, myDy3), Array(myDx3, myDy3))
    myCalculatePoints = Array(myPointA, myPointB, myPointC)
End Function

'' SIG '' Begin signature block
'' SIG '' MIIpyAYJKoZIhvcNAQcCoIIpuTCCKbUCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' ym4v3bbB90/gmaezlW7P9Ws0bhSKolqk5MG2uWXkdleg
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqKMIIahgIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggZww
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIEAz22ZSDzeqyMjf8QovHcvVAGFxjAPoE3sN
'' SIG '' lgeY+R40MDAGCisGAQQBgjcCAQwxIjAgoB6AHABBAGQA
'' SIG '' bwBiAGUAIABJAG4ARABlAHMAaQBnAG4wDQYJKoZIhvcN
'' SIG '' AQEBBQAEggIALr6RRgTBjEaTNeenXk1CI7q3sZ2NC9mS
'' SIG '' 9zbj94KvfqldQFJV5wa1eNasjnYD3r96R0x0ohdS3m7/
'' SIG '' FpjTehTjbvNG0lcJO91n6Hh0dMLp8ZB7ytpzG7hxyjyZ
'' SIG '' hmKMcVUvW/XwR0/GLnuOlUbWQnSO/m3qT6qBTBWPs4Za
'' SIG '' 001whNjQcBZh/lnXYn3BiajK6IfRJ6c/jFjYC5lxRXG2
'' SIG '' rOyGfP8jW9JrC30LQy4idE+42f/Xe3FC6pS+HI2zp+ya
'' SIG '' /Fg0RJAVmkGp+VOWZ59r41QvxHxwQQao6XiTrDLp3145
'' SIG '' 9JdmogUa+fVAe9E+NQjhfOTZYVk7bz2ejTrFW6wGUJBk
'' SIG '' bTYOEFDuZfqWXU1WsUv3jIc+v5IxNzYMbdSSvhXI52oc
'' SIG '' HkwLh2FSSxGECHGdseJwwhj3TyEO6LsN0aUnrkHfvQhW
'' SIG '' 6yncR4Na+7LvTMtUre6O0caMS3IW8c/BO4Ewj6ud6qam
'' SIG '' Dg0tFnXaCjvf1hFGKfNrhO+gg48SiQ3ijgeIVqiuu6eY
'' SIG '' YxjOKDQLT3vkF2TBHWLR0N6nEIMZMAp9ggly+NzEBjWV
'' SIG '' tJlsUFSI6gTOXvY0YfoAZwNfYQFzqfCPTBLMGNv3iIv2
'' SIG '' 28sBFzg5chk32IqtmOQE7I56mtR5+KllEBttO6TWrc6+
'' SIG '' F1pYcNI5hKVeuaKI+6cO5VyXmPof8QDR1XGhghc/MIIX
'' SIG '' OwYKKwYBBAGCNwMDATGCFyswghcnBgkqhkiG9w0BBwKg
'' SIG '' ghcYMIIXFAIBAzEPMA0GCWCGSAFlAwQCAQUAMHcGCyqG
'' SIG '' SIb3DQEJEAEEoGgEZjBkAgEBBglghkgBhv1sBwEwMTAN
'' SIG '' BglghkgBZQMEAgEFAAQgrL3dTgEUg3Vl5emzpa+C53Dq
'' SIG '' fdF7S7eQObURSsiAnwsCEG9EUxupjVTog+h9W1KAiuYY
'' SIG '' DzIwMjQwMTI2MjM1NDQyWqCCEwkwggbCMIIEqqADAgEC
'' SIG '' AhAFRK/zlJ0IOaa/2z9f5WEWMA0GCSqGSIb3DQEBCwUA
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0EwHhcNMjMwNzE0MDAwMDAwWhcNMzQxMDEzMjM1OTU5
'' SIG '' WjBIMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
'' SIG '' cnQsIEluYy4xIDAeBgNVBAMTF0RpZ2lDZXJ0IFRpbWVz
'' SIG '' dGFtcCAyMDIzMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
'' SIG '' MIICCgKCAgEAo1NFhx2DjlusPlSzI+DPn9fl0uddoQ4J
'' SIG '' 3C9Io5d6OyqcZ9xiFVjBqZMRp82qsmrdECmKHmJjadNY
'' SIG '' nDVxvzqX65RQjxwg6seaOy+WZuNp52n+W8PWKyAcwZeU
'' SIG '' tKVQgfLPywemMGjKg0La/H8JJJSkghraarrYO8pd3hkY
'' SIG '' hftF6g1hbJ3+cV7EBpo88MUueQ8bZlLjyNY+X9pD04T1
'' SIG '' 0Mf2SC1eRXWWdf7dEKEbg8G45lKVtUfXeCk5a+B4WZfj
'' SIG '' RCtK1ZXO7wgX6oJkTf8j48qG7rSkIWRw69XloNpjsy7p
'' SIG '' Be6q9iT1HbybHLK3X9/w7nZ9MZllR1WdSiQvrCuXvp/k
'' SIG '' /XtzPjLuUjT71Lvr1KAsNJvj3m5kGQc3AZEPHLVRzapM
'' SIG '' ZoOIaGK7vEEbeBlt5NkP4FhB+9ixLOFRr7StFQYU6mII
'' SIG '' E9NpHnxkTZ0P387RXoyqq1AVybPKvNfEO2hEo6U7Qv1z
'' SIG '' fe7dCv95NBB+plwKWEwAPoVpdceDZNZ1zY8SdlalJPrX
'' SIG '' xGshuugfNJgvOuprAbD3+yqG7HtSOKmYCaFxsmxxrz64
'' SIG '' b5bV4RAT/mFHCoz+8LbH1cfebCTwv0KCyqBxPZySkwS0
'' SIG '' aXAnDU+3tTbRyV8IpHCj7ArxES5k4MsiK8rxKBMhSVF+
'' SIG '' BmbTO77665E42FEHypS34lCh8zrTioPLQHsCAwEAAaOC
'' SIG '' AYswggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8E
'' SIG '' AjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1Ud
'' SIG '' IAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNV
'' SIG '' HSMEGDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNV
'' SIG '' HQ4EFgQUpbbvE+fvzdBkodVWqWUxo97V40kwWgYDVR0f
'' SIG '' BFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1
'' SIG '' NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEE
'' SIG '' gYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
'' SIG '' Z2ljZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2Nh
'' SIG '' Y2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3Rl
'' SIG '' ZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNy
'' SIG '' dDANBgkqhkiG9w0BAQsFAAOCAgEAgRrW3qCptZgXvHCN
'' SIG '' T4o8aJzYJf/LLOTN6l0ikuyMIgKpuM+AqNnn48XtJoKK
'' SIG '' cS8Y3U623mzX4WCcK+3tPUiOuGu6fF29wmE3aEl3o+uQ
'' SIG '' qhLXJ4Xzjh6S2sJAOJ9dyKAuJXglnSoFeoQpmLZXeY/b
'' SIG '' JlYrsPOnvTcM2Jh2T1a5UsK2nTipgedtQVyMadG5K8TG
'' SIG '' e8+c+njikxp2oml101DkRBK+IA2eqUTQ+OVJdwhaIcW0
'' SIG '' z5iVGlS6ubzBaRm6zxbygzc0brBBJt3eWpdPM43UjXd9
'' SIG '' dUWhpVgmagNF3tlQtVCMr1a9TMXhRsUo063nQwBw3syY
'' SIG '' nhmJA+rUkTfvTVLzyWAhxFZH7doRS4wyw4jmWOK22z75
'' SIG '' X7BC1o/jF5HRqsBV44a/rCcsQdCaM0qoNtS5cpZ+l3k4
'' SIG '' SF/Kwtw9Mt911jZnWon49qfH5U81PAC9vpwqbHkB3NpE
'' SIG '' 5jreODsHXjlY9HxzMVWggBHLFAx+rrz+pOt5Zapo1iLK
'' SIG '' O+uagjVXKBbLafIymrLS2Dq4sUaGa7oX/cR3bBVsrquv
'' SIG '' czroSUa31X/MtjjA2Owc9bahuEMs305MfR5ocMB3CtQC
'' SIG '' 4Fxguyj/OOVSWtasFyIjTvTs0xf7UGv/B3cfcZdEQcm4
'' SIG '' RtNsMnxYL2dHZeUbc7aZ+WssBkbvQR7w8F/g29mtkIBE
'' SIG '' r4AQQYowggauMIIElqADAgECAhAHNje3JFR82Ees/Shm
'' SIG '' Kl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVT
'' SIG '' MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsT
'' SIG '' EHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lD
'' SIG '' ZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAw
'' SIG '' MDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVT
'' SIG '' MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UE
'' SIG '' AxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNI
'' SIG '' QTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXH
'' SIG '' JQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI
'' SIG '' 82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR
'' SIG '' 8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU
'' SIG '' 5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3Hxq
'' SIG '' V3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtA
'' SIG '' rF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECn
'' SIG '' wHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu
'' SIG '' 9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz
'' SIG '' 9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpUR
'' SIG '' K1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD
'' SIG '' 4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/
'' SIG '' BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T
'' SIG '' /jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uK
'' SIG '' IqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11G
'' SIG '' deJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzS
'' SIG '' M7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB
'' SIG '' /wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+e
'' SIG '' yG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4c
'' SIG '' D08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsG
'' SIG '' AQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsG
'' SIG '' AQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNV
'' SIG '' HR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAg
'' SIG '' BgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m
'' SIG '' 1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxp
'' SIG '' wc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGId
'' SIG '' DAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqr
'' SIG '' hc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp8
'' SIG '' 76i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeC
'' SIG '' RK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY
'' SIG '' +/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHx
'' SIG '' cpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fx
'' SIG '' ZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhz
'' SIG '' q6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o
'' SIG '' 08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1Oby
'' SIG '' F5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvt
'' SIG '' lUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ
'' SIG '' 8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8
'' SIG '' mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt
'' SIG '' 1nz8MIIFjTCCBHWgAwIBAgIQDpsYjvnQLefv21DiCEAY
'' SIG '' WjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2Vy
'' SIG '' dCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcNMjIwODAxMDAw
'' SIG '' MDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAi
'' SIG '' MGkz7MKnJS7JIT3yithZwuEppz1Yq3aaza57G4QNxDAf
'' SIG '' 8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+
'' SIG '' n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7
'' SIG '' bXHiLQwb7iDVySAdYyktzuxeTsiT+CFhmzTrBcZe7Fsa
'' SIG '' vOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbu
'' SIG '' yntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHE
'' SIG '' tWoYOAMQjdjUN6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6R
'' SIG '' AXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92k
'' SIG '' J7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI
'' SIG '' 8OCiEhtmmnTK3kse5w5jrubU75KSOp493ADkRSWJtppE
'' SIG '' GSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7f/LV
'' SIG '' jHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QY
'' SIG '' uKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+N
'' SIG '' P8m800ERElvlEFDrMcXKchYiCd98THU/Y+whX8QgUWtv
'' SIG '' sauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
'' SIG '' sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB
'' SIG '' /zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' HwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAk
'' SIG '' BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQu
'' SIG '' Y29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5k
'' SIG '' aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290
'' SIG '' Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9j
'' SIG '' cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJ
'' SIG '' RFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0G
'' SIG '' CSqGSIb3DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW
'' SIG '' 1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi7aSId229GhT0
'' SIG '' E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n0
'' SIG '' 96wwepqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE
'' SIG '' 1Od/6Fmo8L8vC6bp8jQ87PcDx4eo0kxAGTVGamlUsLih
'' SIG '' Vo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
'' SIG '' jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt
'' SIG '' 9H5xaiNrIv8SuFQtJ37YOtnwtoeW/VvRXKwYw02fc7cB
'' SIG '' qZ9Xql4o4rmUMYIDdjCCA3ICAQEwdzBjMQswCQYDVQQG
'' SIG '' EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5
'' SIG '' BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5
'' SIG '' NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAFRK/zlJ0I
'' SIG '' Oaa/2z9f5WEWMA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqG
'' SIG '' SIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0B
'' SIG '' CQUxDxcNMjQwMTI2MjM1NDQyWjArBgsqhkiG9w0BCRAC
'' SIG '' DDEcMBowGDAWBBRm8CsywsLJD4JdzqqKycZPGZzPQDAv
'' SIG '' BgkqhkiG9w0BCQQxIgQg9f7ASV/0R7GggH52eW5OFfsI
'' SIG '' A6aZzJ4T85X0JNuzil8wNwYLKoZIhvcNAQkQAi8xKDAm
'' SIG '' MCQwIgQg0vbkbe10IszR1EBXaEE2b4KK2lWarjMWr00a
'' SIG '' mtQMeCgwDQYJKoZIhvcNAQEBBQAEggIAKAhBa0p9Y7wz
'' SIG '' zP535oqKJbZlt+zGrj+SWYNm6AcQ8lkKkwt86AaR0f82
'' SIG '' EbiIyc8tLjCQNSmO2MAyb8+vByGsrdc3QhxHhRPpSmX4
'' SIG '' 9XQivFL4SR89bk3o5mZTdM/jljdoff8Zwd8cRtibsZcd
'' SIG '' or2tboMzFpDK6EF7YARfTbALHpbceHhGARedSk9M9DXi
'' SIG '' 4ORYoXzFN9JlWea4qHkKV/4dn5pfs4mJWBBV27akwatk
'' SIG '' 0fJKQqnS19KLE1RqB5/pwiNNlaqMwULkoj27RPzA3NtP
'' SIG '' IIhuXmFkQR+kd+nzCe8nnFtJOdUQryySexk9ODiBQtvD
'' SIG '' BgJ0XXdhMPKKep7QkRar3RGBT8ftNBHGCGNat6IPe3GL
'' SIG '' YMA5JNYiUSMbMPlnB30cOFRgn9NFhglq+O43nNNMBTqi
'' SIG '' Rg920Z8nLwelKd35hSWI7bw2Lo84VuQVxHdGQdM8/iI5
'' SIG '' /zcp3H9eXtTTTFkAtiV+dKbENzXt3gNRUPZMDfWVKJ/P
'' SIG '' +jqafZ/ml+hyl/0dpXFkrbrQh60ZVQpvF2WV/p6Gjtz4
'' SIG '' ddw0ZcbNpmBC2t48XzUb1m2bd2oOp0bVhFwXltJEdLQ/
'' SIG '' /w2U1B7eJZ9n75rcL1w6VDRtEUQl1Hxho/e+Dq1vzgDr
'' SIG '' k2foIVMwn0em+XGr4+clYLpDFRZRpXSNZQpumgHlnl4P
'' SIG '' 9JR5ybaNM84=
'' SIG '' End signature block
